/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.SRCEntry;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.DateFormatter;
import com.ibm.hsc.websm.frame.CSPStateText;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.cim.UnsignedInt8;

public class PICECDataBean
implements PIDataBeanInterface {
    public static final String KEY_CEC_NAME_USER = "name";
    public static final String KEY_CEC_NEW_NAME_USER = "new_name";
    public static final String KEY_CEC_TYPE_MODEL = "type_model";
    public static final String KEY_CEC_SERIAL = "serial_num";
    public static final String KEY_CEC_CAPABILITY = "capability";
    public static final String KEY_CEC_STATE = "state";
    public static final String KEY_CEC_VPORT = "vport";
    public static final String KEY_CEC_IPADDR = "ipaddr";
    public static final String KEY_CEC_SRC = "src";
    public static final String KEY_CEC_TIME = "sys_time";
    public static final String KEY_CEC_ATTN_LED = "attn_led";
    public static final String KEY_CEC_BRAND = "brand";
    public static final String KEY_PLATFORM_CURR_KEYLOCK_POS = "curr_sys_keylock";
    public static final String KEY_PLATFORM_NEXT_KEYLOCK_POS = "pend_sys_keylock";
    public static final String KEY_PLATFORM_CURR_IPL_SIDE = "curr_power_on_side";
    public static final String KEY_PLATFORM_NEXT_IPL_SIDE = "pend_power_on_side";
    public static final String KEY_PLATFORM_IPL_SIDE = "power_on_side";
    public static final String KEY_PLATFORM_CURR_FSPM_OS_IPL_MODE = "curr_mfg_default_ipl_source";
    public static final String KEY_PLATFORM_NEXT_FSPM_OS_IPL_MODE = "pend_mfg_default_ipl_source";
    public static final String KEY_PLATFORM_CURR_IPL_SPEED = "curr_power_on_speed";
    public static final String KEY_PLATFORM_NEXT_IPL_SPEED = "pend_power_on_speed";
    public static final String KEY_PLATFORM_IPL_SPEED = "power_on_speed";
    public static final String KEY_PLATFORM_CURR_IPL_SPEED_OVERRIDE = "curr_power_on_speed_override";
    public static final String KEY_PLATFORM_NEXT_IPL_SPEED_OVERRIDE = "pend_power_on_speed_override";
    public static final String KEY_PLATFORM_IPL_SPEED_OVERRIDE = "power_on_speed_override";
    public static final String KEY_PLATFORM_CURR_CEC_IPL_ATTRIBUTES = "power_on_attr";
    public static final String KEY_PLATFORM_CURR_CEC_IPL_MAJOR_TYPE = "power_on_type";
    public static final String KEY_PLATFORM_CURR_CEC_IPL_MINOR_TYPE = "power_on_method";
    public static final String KEY_PLATFORM_CURR_HYPERVISOR_IPL_STATE = "power_on_option";
    public static final String KEY_PLATFORM_NEXT_HYPERVISOR_IPL_STATE = "pend_power_on_option";
    public static final String KEY_PLATFORM_CURR_FSPM_LPAR_BOOT_MODE = "curr_mfg_default_boot_mode";
    public static final String KEY_PLATFORM_NEXT_FSPM_LPAR_BOOT_MODE = "pend_mfg_default_boot_mode";
    public static final String KEY_PLATFORM_CURR_FSP_BOOT_ATTRIBUTES = "sp_boot_attr";
    public static final String KEY_PLATFORM_CURR_FSP_BOOT_MAJOR_TYPE = "sp_boot_major_type";
    public static final String KEY_PLATFORM_CURR_FSP_BOOT_MINOR_TYPE = "sp_boot_minor_type";
    public static final String KEY_HYP_NUM_LP_SLOTS = "max_lpars";
    public static final String KEY_HYP_NODE_CAPABILITY = "hyp_capabilities";
    public static final String KEY_HYP_OS400_CAPABILITY = "os400_capable";
    public static final String KEY_5250_APPL_CAPABILITY = "5250_application_capable";
    public static final String KEY_HYP_MICRO_LPAR_CAPABILITY = "micro_lpar_capable";
    public static final String KEY_HYP_SHARED_PROC_CAPABILITY = "shared_proc_capable";
    public static final String KEY_FOD_CAPABILITY = "vet_activation_capable";
    public static final String KEY_HYP_COD_CAPABILITY = "cod_capabilities";
    public static final String KEY_HYP_COD_MEM_CAPABILITY = "cod_mem_capable";
    public static final String KEY_HYP_COD_PROC_CAPABILITY = "cod_proc_capable";
    public static final String KEY_HYP_MEM_REG_SIZE = "mem_region_size";
    public static final String KEY_MAX_MEM_AIX_LINUX = "required_min_mem_aix_linux";
    public static final String KEY_MAX_MEM_OS400 = "required_min_mem_os400";
    public static final String KEY_MAX_MEM_MM = "required_min_mem_mm";
    public static final String KEY_HYP_MAX_HOST_LPARS = "max_power_ctrl_lpars";
    public static final String KEY_HYP_MIN_PROC_PER_VP = "min_proc_units_per_virtual_proc";
    public static final String KEY_HYP_MAX_VPROC_PER_LPAR = "max_virtual_procs_per_lpar";
    public static final String KEY_HYP_MAX_PROC_POOLS = "max_shared_proc_pools";
    public static final String KEY_HYP_MAX_IO_POOLS = "max_io_pools";
    public static final String KEY_HYP_MAX_VLAN_IDS = "max_vlans_per_port";
    public static final String KEY_HYP_SPVERSION = "sp_version";
    public static final String KEY_HYP_TOTAL_BATCH_CPW = "sys_cpw";
    public static final String KEY_HYP_TOTAL_INTERACTIVE_CPW = "sys_5250_cpw";
    public static final String KEY_HYP_ALLOW_HMC_ASSIGN_CPW = "assign_5250_cpw_percent";
    public static final String KEY_HYP_MODE = "mfg_default_config";
    public static final String KEY_HYP_POWER_OFF_POL = "power_off_policy";
    public static final String KEY_HYP_SERVICE_LPAR = "service_lpar_id";
    public static final String KEY_HYP_SERVICE_LPAR_NAME = "service_lpar_name";
    public static final String KEY_INSTALLED_MEM = "installed_sys_mem";
    public static final String KEY_INSTALLED_PROC_UNITS = "installed_sys_proc_units";
    public static final String KEY_HYP_CONF_MEM = "configurable_sys_mem";
    public static final String KEY_HYP_CONF_PROC_UNITS = "configurable_sys_proc_units";
    public static final String KEY_HYP_MAX_I5OS_PROC_UNITS = "max_os400_proc_units";
    public static final String KEY_HYP_MEM = "sys_firmware_mem";
    public static final String KEY_DECONFIG_MEM = "deconfig_sys_mem";
    public static final String KEY_DECONFIG_PROC_UNITS = "deconfig_sys_proc_units";
    public static final String KEY_HYP_CUR_AV_MEM = "curr_avail_sys_mem";
    public static final String KEY_HYP_PEN_AV_MEM = "pend_avail_sys_mem";
    public static final String KEY_HYP_CUR_AV_PROC_UNITS = "curr_avail_sys_proc_units";
    public static final String KEY_HYP_PEN_AV_PROC_UNITS = "pend_avail_sys_proc_units";
    public static final String KEY_HYP_CUR_AV_INTER = "curr_avail_5250_cpw_percent";
    public static final String KEY_HYP_PEN_AV_INTER = "pend_avail_5250_cpw_percent";
    public static final String KEY_HYP_PROC_POOLS = "proc_pools";
    public static final String KEY_HYP_MAC_PREFIX = "mac_prefix";
    public static final String KEY_MIN_INTERACTIVE_PROC = "min_optimal_5250_cpw_percent";
    public static final String KEY_MAX_INTERACTIVE_PROC = "max_optimal_5250_cpw_percent";
    public static final String KEY_VIO_SERVER_CAPABLE = "virtual_io_server_capable";
    public static final String KEY_MM_TYPE_MODEL = "mm_type_model";
    public static final String KEY_MM_SERIAL = "mm_serial_num";
    public static final String KEY_MM_WWNN = "mm_ww_node_num";
    public static final String KEY_MM_SYSTEM_ID = "mm_server_num";
    public static final String KEY_MM_MFG_DATE = "mm_mfg_date";
    public static final String KEY_PASSWORD_STATUS = "password_status";
    public static final String KEY_OP_PANEL_VALUE = "op_panel_value";
    public static final short IPL_SIDE_PERMANENT = 0;
    public static final short IPL_SIDE_TEMPORARY = 1;
    public static final String STRING_IPL_SIDE_PERMANENT = "perm";
    public static final String STRING_IPL_SIDE_TEMPORARY = "temp";
    public static final short IPL_SPEED_SLOW = 16;
    public static final short IPL_SPEED_FAST = 255;
    public static final String STRING_IPL_SPEED_SLOW = "slow";
    public static final String STRING_IPL_SPEED_FAST = "fast";
    public static final short IPL_SPEED_OVERRIDE_NONE = 0;
    public static final short IPL_SPEED_OVERRIDE_SLOW = 16;
    public static final short IPL_SPEED_OVERRIDE_FAST = 255;
    public static final String STRING_IPL_SPEED_OVERRIDE_NONE = "none";
    public static final String STRING_IPL_SPEED_OVERRIDE_SLOW = "slow";
    public static final String STRING_IPL_SPEED_OVERRIDE_FAST = "fast";
    public static final short IPL_MAJOR_TYPE_POWER_ON = 0;
    public static final short IPL_MAJOR_TYPE_RE_IPL = 1;
    public static final String STRING_IPL_MAJOR_TYPE_POWER_ON = "power on";
    public static final String STRING_IPL_MAJOR_TYPE_RE_IPL = "restart";
    public static final short IPL_STATE_AUTOSTART = 2;
    public static final short IPL_STATE_STANDBY = 1;
    public static final String STRING_IPL_STATE_AUTOSTART = "autostart";
    public static final String STRING_IPL_STATE_STANDBY = "standby";
    public static final short SYS_KEYLOCK_MANUAL = 2;
    public static final short SYS_KEYLOCK_NORMAL = 4;
    public static final String STRING_NO_SERVICE_LPAR = "none";
    public static final int VIO_SERVER_NOT_CAPABLE_VALUE = 0;
    public static final int VIO_SERVER_CAPABLE_VALUE = 1;
    public static final short MFG_DEFAULT_CONFIG = 0;
    public static final String[] ALL_KEYS = new String[]{"name", "type_model", "serial_num", "brand", "capability", "state", "src", "vport", "ipaddr", "sys_time", "attn_led", "curr_sys_keylock", "pend_sys_keylock", "curr_power_on_side", "pend_power_on_side", "curr_mfg_default_ipl_source", "pend_mfg_default_ipl_source", "curr_power_on_speed", "pend_power_on_speed", "curr_power_on_speed_override", "pend_power_on_speed_override", "power_on_attr", "power_on_type", "power_on_method", "power_on_option", "pend_power_on_option", "curr_mfg_default_boot_mode", "pend_mfg_default_boot_mode", "sp_boot_attr", "sp_boot_major_type", "sp_boot_minor_type", "max_lpars", "hyp_capabilities", "cod_capabilities", "cod_mem_capable", "cod_proc_capable", "os400_capable", "micro_lpar_capable", "mem_region_size", "max_power_ctrl_lpars", "min_proc_units_per_virtual_proc", "max_shared_proc_pools", "max_io_pools", "max_vlans_per_port", "mac_prefix", "sp_version", "sys_cpw", "sys_5250_cpw", "assign_5250_cpw_percent", "mfg_default_config", "power_off_policy", "service_lpar_id", "service_lpar_name", "installed_sys_mem", "installed_sys_proc_units", "configurable_sys_mem", "configurable_sys_proc_units", "max_os400_proc_units", "sys_firmware_mem", "deconfig_sys_mem", "deconfig_sys_proc_units", "curr_avail_sys_mem", "pend_avail_sys_mem", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "curr_avail_5250_cpw_percent", "pend_avail_5250_cpw_percent", "proc_pools", "mm_type_model", "mm_serial_num", "mm_ww_node_num", "mm_server_num", "mm_mfg_date", "password_status", "op_panel_value", "virtual_io_server_capable", "max_virtual_procs_per_lpar"};
    private String m_userDefinedName;
    public String m_internalName;
    public String m_platformType;
    public String m_platformSerial;
    public String m_cecLocationCode;
    public BitSet m_cecCapability;
    public UnsignedInt8 m_cecState;
    public String m_fspFirmwareLevel;
    public UnsignedInt32 m_vport;
    public String m_ipaddr;
    public UnsignedInt64 m_cecTimeInMillis;
    public String m_cecTimestamp;
    private UnsignedInt16 m_brand;
    private int m_vioServerCapability = -1;
    private Boolean m_sysAttnLed = new Boolean(false);
    public UnsignedInt8 m_platformCurrKeylockPos;
    public UnsignedInt8 m_platformNextKeylockPos;
    public UnsignedInt8 m_platformCurrIplSide;
    public UnsignedInt8 m_platformNextIplSide;
    public UnsignedInt8 m_platformCurrFspmOsIplMode;
    public UnsignedInt8 m_platformNextFspmOsIplMode;
    public UnsignedInt8 m_platformCurrIplSpeed;
    public UnsignedInt8 m_platformNextIplSpeed;
    public UnsignedInt8 m_platformCurrIplSpeedOverride;
    public UnsignedInt8 m_platformNextIplSpeedOverride;
    public UnsignedInt16 m_platformCurrCecIplAttributes;
    public UnsignedInt8 m_platformCurrCecIplMajorType;
    public UnsignedInt8 m_platformCurrCecIplMinorType;
    public UnsignedInt8 m_platformCurrHypervisorIplState;
    public UnsignedInt8 m_platformNextHypervisorIplState;
    public UnsignedInt8 m_platformCurrFspmLparBootMode;
    public UnsignedInt8 m_platformNextFspmLparBootMode;
    public UnsignedInt16 m_platformCurrFspBootAttributes;
    public UnsignedInt8 m_platformCurrFspBootMajorType;
    public UnsignedInt8 m_platformCurrFspBootMinorType;
    public String m_platformIplSide;
    public UnsignedInt16 m_numberOfLPARSlots;
    public UnsignedInt32 m_nodeCapability;
    public BitSet m_codCapability;
    public UnsignedInt16 m_memoryRegionSize;
    public UnsignedInt16 m_maxHostingPartitions;
    public UnsignedInt16 m_minProcUnitsPerVirtualProc;
    public UnsignedInt16 m_maxVirtualProcPerLpar;
    public UnsignedInt8 m_maxProcPools;
    public UnsignedInt16 m_maxIOPools;
    public UnsignedInt16 m_maxVLANIDsPerPort;
    public String m_virtualEthernetMACAddressPrefix;
    public UnsignedInt32 m_totalBatchCPW;
    public UnsignedInt32 m_totalInteractiveCPW;
    public Boolean m_allowHMCAssignCPW;
    public UnsignedInt16 m_minInteractiveProc;
    public UnsignedInt16 m_maxInteractiveProc;
    private UnsignedInt8 m_hvMode;
    private Boolean m_powerOffPolicy;
    private UnsignedInt16 m_servicePartition;
    private String m_servicePartitionName;
    public UnsignedInt32 m_installedMemory;
    public UnsignedInt32 m_installedProcUnits;
    public UnsignedInt32 m_configurableMemory;
    public UnsignedInt32 m_configurableProcUnits;
    public UnsignedInt16 m_maxI5OSProcUnits;
    public UnsignedInt32 m_hypervisorMemory;
    public UnsignedInt32 m_deconfigMemory;
    public UnsignedInt32 m_deconfigProcUnits;
    public UnsignedInt32 m_reqMinMemRPA;
    public UnsignedInt32 m_reqMinMemOS400;
    public UnsignedInt32 m_reqMinMemMM;
    public UnsignedInt32 m_curAvailableMemory;
    public UnsignedInt32 m_pendAvailableMemory;
    public UnsignedInt32 m_curAvailableProcUnits;
    public UnsignedInt32 m_pendAvailableProcUnits;
    public UnsignedInt16 m_curAvailableInteractive;
    public UnsignedInt16 m_pendAvailableInteractive;
    public Hashtable m_processorPools;
    public String m_mmTypeModel;
    public String m_mmSerial;
    public String m_mmWWNN;
    public String m_mmSystemID;
    public String m_mmMfgDate;
    public BitSet m_passwordStatus;
    public SRCEntry m_cecSRC = null;
    public String m_opPanelVal = "";

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public BitSet getCecCapability() {
        return this.m_cecCapability;
    }

    public String getCecLocationCode() {
        return this.m_cecLocationCode;
    }

    public SRCEntry getCecSRC() {
        return this.m_cecSRC;
    }

    public UnsignedInt8 getCecState() {
        return this.m_cecState;
    }

    public UnsignedInt32 getInstalledMemory() {
        return this.m_installedMemory;
    }

    public UnsignedInt32 getInstalledProcUnits() {
        return this.m_installedProcUnits;
    }

    public UnsignedInt32 getConfigurableMemory() {
        return this.m_configurableMemory;
    }

    public UnsignedInt32 getConfigurableProcUnits() {
        return this.m_configurableProcUnits;
    }

    public UnsignedInt16 getMaxI5OSProcUnits() {
        return this.m_maxI5OSProcUnits;
    }

    public UnsignedInt32 getHypervisorMemory() {
        return this.m_hypervisorMemory;
    }

    public UnsignedInt32 getDeconfigMemory() {
        return this.m_deconfigMemory;
    }

    public UnsignedInt32 getDeconfigProcUnits() {
        return this.m_deconfigProcUnits;
    }

    public UnsignedInt16 getCurAvailableInteractive() {
        return this.m_curAvailableInteractive;
    }

    public UnsignedInt32 getCurAvailableMemory() {
        return this.m_curAvailableMemory;
    }

    public UnsignedInt32 getCurAvailableProcUnits() {
        return this.m_curAvailableProcUnits;
    }

    public UnsignedInt16 getMinInteractiveProc() {
        return this.m_minInteractiveProc;
    }

    public UnsignedInt16 getMaxInteractiveProc() {
        return this.m_maxInteractiveProc;
    }

    public String getFspFirmwareLevel() {
        return this.m_fspFirmwareLevel;
    }

    public UnsignedInt16 getMemoryRegionSize() {
        return this.m_memoryRegionSize;
    }

    public UnsignedInt32 getReqMinMemRPA() {
        return this.m_reqMinMemRPA;
    }

    public UnsignedInt32 getReqMinMemOS400() {
        return this.m_reqMinMemOS400;
    }

    public UnsignedInt32 getReqMinMemMM() {
        return this.m_reqMinMemMM;
    }

    public UnsignedInt8 getHvMode() {
        return this.m_hvMode;
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public UnsignedInt16 getMaxHostingPartitions() {
        return this.m_maxHostingPartitions;
    }

    public UnsignedInt16 getBrand() {
        return this.m_brand;
    }

    public UnsignedInt8 getMaxProcPools() {
        return this.m_maxProcPools;
    }

    public UnsignedInt16 getMaxIOPools() {
        return this.m_maxIOPools;
    }

    public UnsignedInt16 getMaxVLANIDsPerPort() {
        return this.m_maxVLANIDsPerPort;
    }

    public UnsignedInt16 getMinProcUnitsPerVirtualProc() {
        return this.m_minProcUnitsPerVirtualProc;
    }

    public UnsignedInt16 getMaxVProcPerLpar() {
        return this.m_maxVirtualProcPerLpar;
    }

    public void setMaxVProcPerLpar(UnsignedInt16 unsignedInt16) {
        this.m_maxVirtualProcPerLpar = unsignedInt16;
    }

    public UnsignedInt32 getNodeCapability() {
        return this.m_nodeCapability;
    }

    public BitSet getCodCapability() {
        return this.m_codCapability;
    }

    public BitSet getPasswordStatus() {
        return this.m_passwordStatus;
    }

    public UnsignedInt16 getNumberOfLPARSlots() {
        return this.m_numberOfLPARSlots;
    }

    public UnsignedInt16 getPendAvailableInteractive() {
        return this.m_pendAvailableInteractive;
    }

    public UnsignedInt32 getPendAvailableMemory() {
        return this.m_pendAvailableMemory;
    }

    public UnsignedInt32 getPendAvailableProcUnits() {
        return this.m_pendAvailableProcUnits;
    }

    public Boolean getPowerOffPolicy() {
        return this.m_powerOffPolicy;
    }

    public Hashtable getProcessorPools() {
        return this.m_processorPools;
    }

    public String getSerial() {
        return this.m_platformSerial;
    }

    public UnsignedInt16 getServicePartition() {
        return this.m_servicePartition;
    }

    public String getServicePartitionName() {
        return this.m_servicePartitionName;
    }

    public String getTypeModel() {
        return this.m_platformType;
    }

    public String getUserDefinedName() {
        return this.m_userDefinedName;
    }

    public UnsignedInt64 getCecTimeInMillis() {
        return this.m_cecTimeInMillis;
    }

    public void setCecTimestamp(String string, String string2) {
        this.m_cecTimestamp = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, Integer.parseInt(stringTokenizer.nextToken()) - 1);
        calendar.set(5, Integer.parseInt(stringTokenizer.nextToken()));
        calendar.set(1, Integer.parseInt(stringTokenizer.nextToken()));
        calendar.set(11, Integer.parseInt(stringTokenizer.nextToken()));
        calendar.set(12, Integer.parseInt(stringTokenizer.nextToken()));
        calendar.set(13, Integer.parseInt(stringTokenizer.nextToken()));
        this.m_cecTimeInMillis = new UnsignedInt64(String.valueOf(calendar.getTimeInMillis()));
    }

    public String getCecTimestamp() {
        return this.m_cecTimestamp;
    }

    public UnsignedInt8 getPlatformCurrKeylockPos() {
        return this.m_platformCurrKeylockPos;
    }

    public UnsignedInt8 getPlatformNextKeylockPos() {
        return this.m_platformNextKeylockPos;
    }

    public UnsignedInt8 getPlatformCurrIplSide() {
        return this.m_platformCurrIplSide;
    }

    public UnsignedInt8 getPlatformNextIplSide() {
        return this.m_platformNextIplSide;
    }

    public UnsignedInt8 getPlatformCurrFspmOsIplMode() {
        return this.m_platformCurrFspmOsIplMode;
    }

    public UnsignedInt8 getPlatformNextFspmOsIplMode() {
        return this.m_platformNextFspmOsIplMode;
    }

    public UnsignedInt8 getPlatformCurrIplSpeed() {
        return this.m_platformCurrIplSpeed;
    }

    public UnsignedInt8 getPlatformNextIplSpeed() {
        return this.m_platformNextIplSpeed;
    }

    public UnsignedInt8 getPlatformCurrIplSpeedOverride() {
        return this.m_platformCurrIplSpeedOverride;
    }

    public UnsignedInt8 getPlatformNextIplSpeedOverride() {
        return this.m_platformNextIplSpeedOverride;
    }

    public UnsignedInt16 getPlatformCurrCecIplAttributes() {
        return this.m_platformCurrCecIplAttributes;
    }

    public UnsignedInt8 getPlatformCurrCecIplMajorType() {
        return this.m_platformCurrCecIplMajorType;
    }

    public UnsignedInt8 getPlatformCurrCecIplMinorType() {
        return this.m_platformCurrCecIplMinorType;
    }

    public UnsignedInt8 getPlatformCurrHypervisorIplState() {
        return this.m_platformCurrHypervisorIplState;
    }

    public UnsignedInt8 getPlatformNextHypervisorIplState() {
        return this.m_platformNextHypervisorIplState;
    }

    public UnsignedInt8 getPlatformCurrFspmLparBootMode() {
        return this.m_platformCurrFspmLparBootMode;
    }

    public UnsignedInt8 getPlatformNextFspmLparBootMode() {
        return this.m_platformNextFspmLparBootMode;
    }

    public UnsignedInt16 getPlatformCurrFspBootAttributes() {
        return this.m_platformCurrFspBootAttributes;
    }

    public UnsignedInt8 getPlatformCurrFspBootMajorType() {
        return this.m_platformCurrFspBootMajorType;
    }

    public UnsignedInt8 getPlatformCurrFspBootMinorType() {
        return this.m_platformCurrFspBootMinorType;
    }

    public String getPlatformIplSide() {
        return this.m_platformIplSide;
    }

    public String getPlatformType() {
        return this.m_platformType;
    }

    public String getPlatformSerial() {
        return this.m_platformSerial;
    }

    public UnsignedInt32 getTotalBatchCPW() {
        return this.m_totalBatchCPW;
    }

    public UnsignedInt32 getTotalInteractiveCPW() {
        return this.m_totalInteractiveCPW;
    }

    public String getVirtualEthernetMACAddressPrefix() {
        return this.m_virtualEthernetMACAddressPrefix;
    }

    public UnsignedInt32 getVPort() {
        return this.m_vport;
    }

    public String getIpAddress() {
        return this.m_ipaddr;
    }

    public String getMmTypeModel() {
        return this.m_mmTypeModel;
    }

    public String getMmSerial() {
        return this.m_mmSerial;
    }

    public String getMmWWNN() {
        return this.m_mmWWNN;
    }

    public String getMmSystemID() {
        return this.m_mmSystemID;
    }

    public String getMfgDate() {
        return this.m_mmMfgDate;
    }

    public int getVirtualIOServerCapability() {
        return this.m_vioServerCapability;
    }

    public void setVPort(UnsignedInt32 unsignedInt32) {
        this.m_vport = unsignedInt32;
    }

    public void setBrand(UnsignedInt16 unsignedInt16) {
        this.m_brand = unsignedInt16;
    }

    public void setPlatformType(String string) {
        this.m_platformType = string;
    }

    public void setPlatformSerial(String string) {
        this.m_platformSerial = string;
    }

    public void setTotalBatchCPW(UnsignedInt32 unsignedInt32) {
        this.m_totalBatchCPW = unsignedInt32;
    }

    public void setTotalInteractiveCPW(UnsignedInt32 unsignedInt32) {
        this.m_totalInteractiveCPW = unsignedInt32;
    }

    public void setHvMode(UnsignedInt8 unsignedInt8) {
        this.m_hvMode = unsignedInt8;
    }

    public void setPowerOffPolicy(Boolean bl) {
        this.m_powerOffPolicy = bl;
    }

    public void setServicePartition(UnsignedInt16 unsignedInt16) {
        this.m_servicePartition = unsignedInt16;
    }

    public void setServicePartitionName(String string) {
        this.m_servicePartitionName = string;
    }

    public void setUserDefinedName(String string) {
        this.m_userDefinedName = string;
    }

    public void setPlatformNextKeylockPos(UnsignedInt8 unsignedInt8) {
        this.m_platformNextKeylockPos = unsignedInt8;
    }

    public void setPlatformNextIplSide(UnsignedInt8 unsignedInt8) {
        this.m_platformNextIplSide = unsignedInt8;
    }

    public void setPlatformNextFspmOsIplMode(UnsignedInt8 unsignedInt8) {
        this.m_platformNextFspmOsIplMode = unsignedInt8;
    }

    public void setPlatformNextIplSpeed(UnsignedInt8 unsignedInt8) {
        this.m_platformNextIplSpeed = unsignedInt8;
    }

    public void setPlatformNextIplSpeedOverride(UnsignedInt8 unsignedInt8) {
        this.m_platformNextIplSpeedOverride = unsignedInt8;
    }

    public void setPlatformNextHypervisorIplState(UnsignedInt8 unsignedInt8) {
        this.m_platformNextHypervisorIplState = unsignedInt8;
    }

    public void setPlatformNextFspmLparBootMode(UnsignedInt8 unsignedInt8) {
        this.m_platformNextFspmLparBootMode = unsignedInt8;
    }

    public void setMmTypeModel(String string) {
        this.m_mmTypeModel = string;
    }

    public void setMmSerial(String string) {
        this.m_mmSerial = string;
    }

    public void setMmWWNN(String string) {
        this.m_mmWWNN = string;
    }

    public void setMmSystemID(String string) {
        this.m_mmSystemID = string;
    }

    public void setReqMinMemRPA(UnsignedInt32 unsignedInt32) {
        this.m_reqMinMemRPA = unsignedInt32;
    }

    public void setReqMinMemOS400(UnsignedInt32 unsignedInt32) {
        this.m_reqMinMemOS400 = unsignedInt32;
    }

    public void setReqMinMemMM(UnsignedInt32 unsignedInt32) {
        this.m_reqMinMemMM = unsignedInt32;
    }

    public void setMmMfgDate(String string) {
        this.m_mmMfgDate = string;
    }

    public String getOpPanelVal() {
        return this.m_opPanelVal;
    }

    public Boolean getAllowHMCAssignCPW() {
        return this.m_allowHMCAssignCPW;
    }

    public void setAllowHMCAssignCPW(Boolean bl) {
        this.m_allowHMCAssignCPW = bl;
    }

    public void setMinInteractiveProc(UnsignedInt16 unsignedInt16) {
        this.m_minInteractiveProc = unsignedInt16;
    }

    public void setMaxInteractiveProc(UnsignedInt16 unsignedInt16) {
        this.m_maxInteractiveProc = unsignedInt16;
    }

    public void setVIOServerCapability(int n) {
        this.m_vioServerCapability = n;
    }

    public boolean isOS400Capable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x40000000) != 0;
    }

    public boolean is5250CapabilityKnown() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x1000000) != 0;
    }

    public boolean is5250Capable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x800000) != 0;
    }

    public boolean isSharedProcCapable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x10000000) != 0;
    }

    public boolean isFoDCapable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x4000000) != 0;
    }

    public boolean isHSLOptiConnectCapable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x100) != 0;
    }

    public boolean isCUoDCapable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x20000000) != 0;
    }

    public boolean isCodMemCapable() {
        if (this.m_codCapability != null) {
            return this.m_codCapability.get(1);
        }
        return false;
    }

    public boolean isCodProcCapable() {
        if (this.m_codCapability != null) {
            return this.m_codCapability.get(0);
        }
        return false;
    }

    public boolean isMessagePassingCapable() {
        int n;
        return this.m_nodeCapability != null && ((n = this.m_nodeCapability.intValue()) & 0x20) != 0;
    }

    public boolean isInteractiveHMCManaged() {
        boolean bl = false;
        if (this.m_allowHMCAssignCPW != null) {
            bl = this.m_allowHMCAssignCPW;
        }
        return this.isOS400Capable() && bl;
    }

    public boolean isMfgDefaultConfig() {
        return this.m_hvMode != null && this.m_hvMode.shortValue() == 0;
    }

    public boolean isIOServerCapable() {
        if (this.m_nodeCapability != null) {
            int n = this.m_nodeCapability.intValue();
            if ((n & 0x8000000) == 0x8000000) {
                return true;
            }
        } else {
            System.out.println("NODE NULL");
        }
        return false;
    }

    public boolean isOS400ProcCapacityLimited() {
        boolean bl = false;
        if (this.m_maxI5OSProcUnits.intValue() > 0) {
            bl = true;
        }
        return this.isOS400Capable() && bl;
    }

    public boolean isOS400IoServerCapable() {
        int n;
        return this.m_nodeCapability == null || ((n = this.m_nodeCapability.intValue()) & 0x2000000) == 0;
    }

    public Boolean getSysAttnLed() {
        return this.m_sysAttnLed;
    }

    public void setSysAttnLed(Boolean bl) {
        if (bl != null) {
            this.m_sysAttnLed = bl;
        }
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string2 = stringArray[i];
            if (KEY_CEC_NAME_USER.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_userDefinedName, bl);
                continue;
            }
            if (KEY_CEC_TYPE_MODEL.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_platformType, bl);
                continue;
            }
            if (KEY_CEC_SERIAL.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_platformSerial, bl);
                continue;
            }
            if (KEY_CEC_CAPABILITY.equals(string2)) {
                object = "";
                if (this.m_cecCapability != null) {
                    object = this.m_cecCapability.toString();
                }
                CSVRecord.append(cSVRecord, string2, (String)object, bl);
                continue;
            }
            if (KEY_PASSWORD_STATUS.equals(string2)) {
                object = "";
                if (this.m_passwordStatus != null) {
                    object = this.m_passwordStatus.toString();
                }
                CSVRecord.append(cSVRecord, string2, (String)object, bl);
                continue;
            }
            if (KEY_CEC_STATE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getCECStateString(), bl);
                continue;
            }
            if (KEY_CEC_SRC.equals(string2)) {
                if (this.m_cecSRC != null) {
                    CSVRecord.append(cSVRecord, string2, this.m_cecSRC.toString(), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "", bl);
                continue;
            }
            if (KEY_CEC_TIME.equals(string2)) {
                if (this.m_cecTimeInMillis != null) {
                    object = DateFormatter.getDefaultInstance();
                    String string3 = ((DateFormatter)object).formatDateTime(this.m_cecTimeInMillis.longValue());
                    CSVRecord.append(cSVRecord, string2, string3, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_CEC_ATTN_LED.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, "TODO", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_KEYLOCK_POS.equals(string2)) {
                if (this.m_platformCurrKeylockPos != null) {
                    CSVRecord.append(cSVRecord, string2, this.getPlatformKeylockString(this.m_platformCurrKeylockPos), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_KEYLOCK_POS.equals(string2)) {
                if (this.m_platformNextKeylockPos != null) {
                    CSVRecord.append(cSVRecord, string2, this.getPlatformKeylockString(this.m_platformNextKeylockPos), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_IPL_SIDE.equals(string2)) {
                if (this.m_platformCurrIplSide != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplSideString(this.m_platformCurrIplSide), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_IPL_SIDE.equals(string2)) {
                if (this.m_platformNextIplSide != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplSideString(this.m_platformNextIplSide), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_FSPM_OS_IPL_MODE.equals(string2)) {
                if (this.m_platformCurrFspmOsIplMode != null) {
                    CSVRecord.append(cSVRecord, string2, PILPARDataBean.getIplSourceString(this.m_platformCurrFspmOsIplMode, true), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_FSPM_OS_IPL_MODE.equals(string2)) {
                if (this.m_platformNextFspmOsIplMode != null) {
                    CSVRecord.append(cSVRecord, string2, PILPARDataBean.getIplSourceString(this.m_platformNextFspmOsIplMode, true), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_IPL_SPEED.equals(string2)) {
                if (this.m_platformCurrIplSpeed != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplSpeedString(this.m_platformCurrIplSpeed), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_IPL_SPEED.equals(string2)) {
                if (this.m_platformNextIplSpeed != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplSpeedString(this.m_platformNextIplSpeed), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_IPL_SPEED_OVERRIDE.equals(string2)) {
                if (this.m_platformCurrIplSpeedOverride != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplSpeedOverrideString(this.m_platformCurrIplSpeedOverride), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_IPL_SPEED_OVERRIDE.equals(string2)) {
                if (this.m_platformNextIplSpeedOverride != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplSpeedOverrideString(this.m_platformNextIplSpeedOverride), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_CEC_IPL_ATTRIBUTES.equals(string2)) {
                if (this.m_platformCurrCecIplAttributes != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_platformCurrCecIplAttributes), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_CEC_IPL_MAJOR_TYPE.equals(string2)) {
                if (this.m_platformCurrCecIplMajorType != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplMajorTypeString(this.m_platformCurrCecIplMajorType), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_CEC_IPL_MINOR_TYPE.equals(string2)) {
                if (this.m_platformCurrCecIplMinorType != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)this.m_platformCurrCecIplMinorType, 2), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_HYPERVISOR_IPL_STATE.equals(string2)) {
                if (this.m_platformCurrHypervisorIplState != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplStateString(this.m_platformCurrHypervisorIplState), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_HYPERVISOR_IPL_STATE.equals(string2)) {
                if (this.m_platformNextHypervisorIplState != null) {
                    CSVRecord.append(cSVRecord, string2, this.getIplStateString(this.m_platformNextHypervisorIplState), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_FSPM_LPAR_BOOT_MODE.equals(string2)) {
                if (this.m_platformCurrFspmLparBootMode != null) {
                    CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getBootModeString(this.m_platformCurrFspmLparBootMode, false), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_NEXT_FSPM_LPAR_BOOT_MODE.equals(string2)) {
                if (this.m_platformNextFspmLparBootMode != null) {
                    CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getBootModeString(this.m_platformNextFspmLparBootMode, false), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_FSP_BOOT_ATTRIBUTES.equals(string2)) {
                if (this.m_platformCurrFspBootAttributes != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString(this.m_platformCurrFspBootAttributes), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_FSP_BOOT_MAJOR_TYPE.equals(string2)) {
                if (this.m_platformCurrFspBootMajorType != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)this.m_platformCurrFspBootMajorType, 2), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_PLATFORM_CURR_FSP_BOOT_MINOR_TYPE.equals(string2)) {
                if (this.m_platformCurrFspBootMinorType != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)this.m_platformCurrFspBootMinorType, 2), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_SPVERSION.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_fspFirmwareLevel, bl);
                continue;
            }
            if (KEY_HYP_TOTAL_BATCH_CPW.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_totalBatchCPW, bl);
                continue;
            }
            if (KEY_HYP_TOTAL_INTERACTIVE_CPW.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_totalInteractiveCPW, bl);
                continue;
            }
            if (KEY_HYP_ALLOW_HMC_ASSIGN_CPW.equals(string2)) {
                if (this.m_allowHMCAssignCPW != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.m_allowHMCAssignCPW), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_NUM_LP_SLOTS.equals(string2)) {
                if (this.m_numberOfLPARSlots != null) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_numberOfLPARSlots, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_NODE_CAPABILITY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_nodeCapability, bl);
                continue;
            }
            if (KEY_HYP_OS400_CAPABILITY.equals(string2)) {
                if (this.m_nodeCapability != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.isOS400Capable()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_5250_APPL_CAPABILITY.equals(string2)) {
                if (bl && !this.is5250CapabilityKnown()) continue;
                if (this.is5250CapabilityKnown()) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.is5250Capable()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_MICRO_LPAR_CAPABILITY.equals(string2) || KEY_HYP_SHARED_PROC_CAPABILITY.equals(string2)) {
                if (this.m_nodeCapability != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.isSharedProcCapable()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_COD_CAPABILITY.equals(string2)) {
                if (this.m_codCapability != null) {
                    CSVRecord.append(cSVRecord, string2, this.m_codCapability.toString(), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_COD_MEM_CAPABILITY.equals(string2)) {
                if (this.m_codCapability != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.isCodMemCapable()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_COD_PROC_CAPABILITY.equals(string2)) {
                if (this.m_codCapability != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.isCodProcCapable()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_FOD_CAPABILITY.equals(string2)) {
                if (this.m_nodeCapability != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.isFoDCapable()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_MEM_REG_SIZE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_memoryRegionSize, bl);
                continue;
            }
            if (KEY_MAX_MEM_AIX_LINUX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_reqMinMemRPA, bl);
                continue;
            }
            if (KEY_MAX_MEM_OS400.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_reqMinMemOS400, bl);
                continue;
            }
            if (KEY_MAX_MEM_MM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_reqMinMemMM, bl);
                continue;
            }
            if (KEY_HYP_MAX_HOST_LPARS.equals(string2)) {
                if (this.m_maxHostingPartitions != null) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_maxHostingPartitions, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_MIN_PROC_PER_VP.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_minProcUnitsPerVirtualProc), bl);
                continue;
            }
            if (KEY_HYP_MAX_PROC_POOLS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_maxProcPools, bl);
                continue;
            }
            if (KEY_HYP_MAX_IO_POOLS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_maxIOPools, bl);
                continue;
            }
            if (KEY_HYP_MAX_VLAN_IDS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_maxVLANIDsPerPort, bl);
                continue;
            }
            if (KEY_HYP_MAC_PREFIX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_virtualEthernetMACAddressPrefix == null ? "" : this.m_virtualEthernetMACAddressPrefix, bl);
                continue;
            }
            if (KEY_HYP_MODE.equals(string2)) {
                if (this.m_hvMode != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.isMfgDefaultConfig()), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_POWER_OFF_POL.equals(string2)) {
                if (this.m_powerOffPolicy != null) {
                    CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertBooleanToString(this.m_powerOffPolicy), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_SERVICE_LPAR.equals(string2)) {
                if (this.m_servicePartition != null) {
                    if (this.m_servicePartition.intValue() == 65535) {
                        CSVRecord.append(cSVRecord, string2, "none", bl);
                        continue;
                    }
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_servicePartition, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_HYP_SERVICE_LPAR_NAME.equals(string2)) {
                if (this.m_servicePartitionName != null) {
                    CSVRecord.append(cSVRecord, string2, this.m_servicePartitionName, bl);
                    continue;
                }
                if (this.m_servicePartition != null && this.m_servicePartition.intValue() == 65535) {
                    if (bl) continue;
                    CSVRecord.append(cSVRecord, string2, (String)null, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (KEY_INSTALLED_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_installedMemory, bl);
                continue;
            }
            if (KEY_INSTALLED_PROC_UNITS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_installedProcUnits), bl);
                continue;
            }
            if (KEY_HYP_CONF_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_configurableMemory, bl);
                continue;
            }
            if (KEY_HYP_CONF_PROC_UNITS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_configurableProcUnits), bl);
                continue;
            }
            if (KEY_HYP_MAX_I5OS_PROC_UNITS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_maxI5OSProcUnits), bl);
                continue;
            }
            if (KEY_HYP_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_hypervisorMemory, bl);
                continue;
            }
            if (KEY_DECONFIG_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_deconfigMemory, bl);
                continue;
            }
            if (KEY_DECONFIG_PROC_UNITS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_deconfigProcUnits), bl);
                continue;
            }
            if (KEY_HYP_CUR_AV_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curAvailableMemory, bl);
                continue;
            }
            if (KEY_HYP_PEN_AV_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendAvailableMemory, bl);
                continue;
            }
            if (KEY_HYP_CUR_AV_PROC_UNITS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curAvailableProcUnits), bl);
                continue;
            }
            if (KEY_HYP_PEN_AV_PROC_UNITS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendAvailableProcUnits), bl);
                continue;
            }
            if (KEY_HYP_CUR_AV_INTER.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curAvailableInteractive), bl);
                continue;
            }
            if (KEY_HYP_PEN_AV_INTER.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendAvailableInteractive), bl);
                continue;
            }
            if (KEY_MM_TYPE_MODEL.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_mmTypeModel, bl);
                continue;
            }
            if (KEY_MM_SERIAL.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_mmSerial, bl);
                continue;
            }
            if (KEY_MM_WWNN.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_mmWWNN, bl);
                continue;
            }
            if (KEY_MM_SYSTEM_ID.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_mmSystemID, bl);
                continue;
            }
            if (KEY_MM_MFG_DATE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_mmMfgDate, bl);
                continue;
            }
            if (KEY_CEC_IPADDR.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_ipaddr, bl);
                continue;
            }
            if (KEY_MIN_INTERACTIVE_PROC.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_minInteractiveProc), bl);
                continue;
            }
            if (KEY_MAX_INTERACTIVE_PROC.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_maxInteractiveProc), bl);
                continue;
            }
            if (KEY_VIO_SERVER_CAPABLE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, new Integer(this.m_vioServerCapability).toString(), bl);
                continue;
            }
            if (!KEY_HYP_MAX_VPROC_PER_LPAR.equals(string2)) continue;
            CSVRecord.append(cSVRecord, string2, (Number)this.m_maxVirtualProcPerLpar, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    public String getCECStateString() {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String string = CSPStateText.getStateValue(this.m_cecState.intValue());
        Locale.setDefault(locale);
        return string;
    }

    private String getPlatformKeylockString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.shortValue() == 2) {
            return "manual";
        }
        if (unsignedInt8.shortValue() == 4) {
            return "norm";
        }
        return unsignedInt8.toString();
    }

    private String getIplSideString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.shortValue() == 0) {
            return STRING_IPL_SIDE_PERMANENT;
        }
        if (unsignedInt8.shortValue() == 1) {
            return STRING_IPL_SIDE_TEMPORARY;
        }
        return unsignedInt8.toString();
    }

    private String getIplSpeedString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.shortValue() == 16) {
            return "slow";
        }
        if (unsignedInt8.shortValue() == 255) {
            return "fast";
        }
        return unsignedInt8.toString();
    }

    private String getIplSpeedOverrideString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.shortValue() == 0) {
            return "none";
        }
        if (unsignedInt8.shortValue() == 16) {
            return "slow";
        }
        if (unsignedInt8.shortValue() == 255) {
            return "fast";
        }
        return unsignedInt8.toString();
    }

    private String getIplMajorTypeString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.shortValue() == 0) {
            return STRING_IPL_MAJOR_TYPE_POWER_ON;
        }
        if (unsignedInt8.shortValue() == 1) {
            return STRING_IPL_MAJOR_TYPE_RE_IPL;
        }
        return unsignedInt8.toString();
    }

    private String getIplStateString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8.shortValue() == 2) {
            return STRING_IPL_STATE_AUTOSTART;
        }
        if (unsignedInt8.shortValue() == 1) {
            return STRING_IPL_STATE_STANDBY;
        }
        return unsignedInt8.toString();
    }
}

